from sympy import *
from scipy.integrate import quad

dot=lambda u,v:sum([a*b for (a,b) in zip(u,v)])
mag=lambda u:sqrt(dot(u,u))
scale=lambda c,u:[c*a for a in u]
unit=lambda u:scale(1/mag(u),u)

d=lambda u,x:[diff(c,x) for c in u]
at=lambda u,x,a:[c.subs(x,a) for c in u]
numint=lambda f,x,a,b:quad(lambdify(x,f),a,b)[0]

t=symbols('t')
r=[sin(t)*cos(20*t),sin(t)*sin(20*t),cos(t)]
v=d(r,t)
T=unit(v)
for t0 in [1.,2.,3.]:
    print('r at '+str(t0)+' = '+str(at(r,t,t0)))
    print('v at '+str(t0)+' = '+str(at(v,t,t0)))
    print('T at '+str(t0)+' = '+str(at(T,t,t0)))
    print()

speed=simplify(mag(v))
print('speed = '+str(speed))
length=numint(speed,t,0,pi)
print('arc length = '+str(length))
