from sympy import *
from scipy.integrate import quad

dot=lambda u,v:sum([a*b for (a,b) in zip(u,v)])
mag=lambda u:sqrt(dot(u,u))
scale=lambda c,u:[c*a for a in u]
unit=lambda u:scale(1/mag(u),u)
plus=lambda u,v:[x+y for (x,y) in zip(u,v)]
approx=lambda u:[N(a) for a in u]

d=lambda u,x:[diff(c,x) for c in u]
at=lambda u,x,a:[c.subs(x,a) for c in u]
numint=lambda f,x,a,b:quad(lambdify(x,f),a,b)[0]

def osc_circ_params(r,t):
    v=d(r,t)
    T=unit(v)
    Tp=simplify(d(T,t))

    t0=pi/4
    r0,v0,T0,Tp0=[simplify(at(u,t,t0)) for u in [r,v,T,Tp]]
    N0=unit(Tp0)
    R0=simplify(mag(v0)/mag(Tp0))
    circ=plus(r0,scale(R0,plus(scale(cos(t),T0),scale(1+sin(t),N0))))

    at_string=' at t='+str(t0)
    print('r_curve = '+str(r)+' = '+str(r0)+at_string)
    print('T = '+str(T)+' = '+str(T0)+at_string)
    print('T\' = '+str(Tp)+' = '+str(Tp0)+at_string)
    print('N = '+str(N0)+at_string)
    print('R = '+str(R0)+at_string)
    print('r_circle = '+str(approx(circ)))
    print()

t=symbols('t')
for r in [[7*cos(t),4*sin(t)],[7*cos(t),4*sin(t),t]]:
    osc_circ_params(r,t)


