import numpy as np
import matplotlib.pyplot as plt

logit=lambda x:np.log(x/(1-x))
ilogit=lambda y:1/(1+np.exp(-y))

x=np.linspace(0,1,1000)

plt.xlim(-.1,1.1)
plt.ylim(-.1,1.1)

def llplot(slope,intercept):
    f=lambda t:ilogit(slope*logit(t)+intercept)
    y=[f(p) for p in x]
    plt.plot(x,y)

for b in np.arange(-5,5,1):
    llplot(1,b)
    
plt.show()

for m in np.arange(-5,5,1):
    llplot(m,1)
    
plt.show()
